/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.runtime.step.beans;

import filenet.vw.api.VWAttachment;
import filenet.vw.api.VWParameter;
import filenet.vw.base.VWDebug;
import filenet.vw.idm.toolkit.IVWIDMItem;
import filenet.vw.idm.toolkit.VWIDMBaseFactory;
import filenet.vw.toolkit.runtime.step.IVWPanelComponent;
import filenet.vw.toolkit.runtime.step.IVWStepProcessorComponent;
import filenet.vw.toolkit.runtime.step.beans.VWPanel;
import filenet.vw.toolkit.runtime.step.resources.VWResource;
import filenet.vw.toolkit.utils.VWHelp;
import filenet.vw.toolkit.utils.VWSessionInfo;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.dialog.VWModalDialog;
import java.net.URLDecoder;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.StringTokenizer;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public class VWLaunchPanel
extends VWPanel {
    public void init(VWSessionInfo sessionInfo) {
        try {
            String attachDocID;
            String subject;
            this.m_parentContainer = sessionInfo.getParentContainer();
            this.m_parentApplet = sessionInfo.getParentApplet();
            this.m_vwSession = sessionInfo.getSession();
            String workflowDocID = null;
            String tmpStringToDecode = sessionInfo.getProperty("workflowDefinitionDocID");
            if (tmpStringToDecode != null && tmpStringToDecode.length() > 0) {
                workflowDocID = URLDecoder.decode(tmpStringToDecode);
            }
            if (this.m_vwSession != null) {
                try {
                    Locale browserLocale = sessionInfo.getBrowserLocale();
                    if (browserLocale != null) {
                        this.m_vwSession.setClientLocale(browserLocale);
                    }
                }
                catch (Exception ex) {
                    VWDebug.logException(ex);
                }
            }
            this.m_cancelWarningMsg = VWResource.s_cancelLaunchWarning;
            this.m_confirmCancelMsg = VWResource.s_confirmLaunchCancel;
            this.m_failedToCompleteMsg = VWResource.s_failedLaunching;
            this.m_failedToCancelMsg = VWResource.s_failedCancellingLaunch;
            if (this.m_parentContainer != null && this.m_parentContainer instanceof JFrame) {
                this.m_parentContainer.setSize(sessionInfo.getRequestedWidth(), sessionInfo.getRequestedHeight());
            }
            this.m_parentFrame = VWModalDialog.getParentFrameUsingContainer(this.m_parentContainer);
            if (!this.createWorkflow(workflowDocID)) {
                JOptionPane.showMessageDialog(this.m_parentFrame, VWResource.s_unableToOpenStepElement, VWResource.s_failedOpeningStep, 0);
                this.doClose();
            }
            if ((subject = sessionInfo.getProperty("subject")) != null && subject.length() > 0 && this.m_vwStepElement.hasParameterName("F_Subject")) {
                this.m_vwStepElement.setParameterValue("F_Subject", subject, true);
            }
            if ((attachDocID = sessionInfo.getProperty("mainAttachmentDocID")) != null && attachDocID.length() > 0 && this.m_vwStepElement.hasParameterName("F_MAINATTACHMENT")) {
                String mainAttachmentParameterName = (String)this.m_vwStepElement.getParameterValue("F_MAINATTACHMENT");
                VWParameter[] attachmentParameters = this.m_vwStepElement.getParameters(32, 3);
                VWParameter mainAttachmentParameter = null;
                if (attachmentParameters != null) {
                    for (int i = 0; i < attachmentParameters.length; ++i) {
                        if (VWStringUtils.compare(attachmentParameters[i].getName(), mainAttachmentParameterName) != 0) continue;
                        mainAttachmentParameter = attachmentParameters[i];
                    }
                }
                if (mainAttachmentParameter != null) {
                    IVWIDMItem actualIDMItem = null;
                    VWAttachment mainAttachment = null;
                    try {
                        actualIDMItem = VWIDMBaseFactory.instance().getIDMItem(attachDocID);
                        if (actualIDMItem != null) {
                            mainAttachment = actualIDMItem.getVWAttachment();
                        }
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                    if (mainAttachment == null) {
                        try {
                            mainAttachment = new VWAttachment(attachDocID);
                        }
                        catch (Exception ex) {
                            VWDebug.logException(ex);
                        }
                    }
                    if (mainAttachment != null) {
                        if (mainAttachmentParameter.isArray()) {
                            VWAttachment[] tempAttachArray = null;
                            if (this.isAttachmentArrayEmpty(mainAttachmentParameter)) {
                                tempAttachArray = new VWAttachment[]{mainAttachment};
                            } else {
                                VWAttachment[] attachArray = (VWAttachment[])mainAttachmentParameter.getValue();
                                tempAttachArray = new VWAttachment[attachArray.length + 1];
                                for (int i = 0; i < attachArray.length; ++i) {
                                    tempAttachArray[i] = attachArray[i];
                                }
                                tempAttachArray[attachArray.length] = mainAttachment;
                            }
                            this.m_vwStepElement.setParameterValue(mainAttachmentParameterName, tempAttachArray, false);
                        } else {
                            this.m_vwStepElement.setParameterValue(mainAttachmentParameterName, mainAttachment, true);
                        }
                        try {
                            switch (mainAttachment.getType()) {
                                case 0: 
                                case 1: 
                                case 5: {
                                    break;
                                }
                                default: {
                                    String propertyMap;
                                    if (actualIDMItem == null) {
                                        actualIDMItem = VWIDMBaseFactory.instance().getIDMItemFromVWAttachment(mainAttachment);
                                    }
                                    if (actualIDMItem != null && (tmpStringToDecode = sessionInfo.getProperty("propertyMap")) != null && tmpStringToDecode.length() > 0 && (propertyMap = URLDecoder.decode(tmpStringToDecode)) != null && propertyMap.length() > 0) {
                                        this.processPropertyMap(propertyMap, actualIDMItem);
                                    }
                                    break;
                                }
                            }
                        }
                        catch (Exception ex) {
                            VWDebug.logException(ex);
                        }
                    }
                }
            }
            if (this.m_componentList != null) {
                for (int i = 0; i < this.m_componentList.size(); ++i) {
                    Object obj = this.m_componentList.elementAt(i);
                    if (obj instanceof IVWPanelComponent) {
                        ((IVWPanelComponent)obj).setStepElement(this.m_vwStepElement);
                        continue;
                    }
                    if (!(obj instanceof IVWStepProcessorComponent)) continue;
                    ((IVWStepProcessorComponent)obj).init(this.m_vwStepElement, this.m_parentFrame, this.m_vwSession);
                }
            }
            this.performExtraLoadOperations();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            this.doClose();
        }
    }

    protected void displayHelp() {
        try {
            VWHelp.displayPage(VWHelp.Help_General + "bpfsp012.htm");
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    protected void doAbort() {
    }

    private boolean createWorkflow(String wfDocID) {
        try {
            if (this.m_vwSession == null) {
                return false;
            }
            this.m_vwStepElement = this.m_vwSession.createWorkflow(wfDocID);
            if (this.m_vwStepElement == null) {
                return false;
            }
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this.m_parentFrame, ex, VWResource.s_failedCreatingWorkflow, 0);
            VWDebug.logException(ex);
            return false;
        }
        return true;
    }

    private boolean isAttachmentArrayEmpty(VWParameter parameter) {
        try {
            VWAttachment[] attachmentArray = (VWAttachment[])parameter.getValue();
            if (attachmentArray == null) {
                return true;
            }
            if (attachmentArray.length == 1 && attachmentArray[0].getAttachmentName() == null) {
                return true;
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return false;
    }

    private void processPropertyMap(String propertyMap, IVWIDMItem mainAttachment) {
        try {
            if (propertyMap != null && propertyMap.length() > 0 && this.m_vwStepElement != null) {
                StringTokenizer tokenizer = new StringTokenizer(propertyMap, ",");
                while (tokenizer.hasMoreTokens()) {
                    Object propertyValue;
                    String sItemMap = tokenizer.nextToken();
                    String parameterName = sItemMap.substring(0, sItemMap.indexOf(61));
                    String propertyName = sItemMap.substring(sItemMap.indexOf(61) + 1, sItemMap.length());
                    if (!this.m_vwStepElement.hasParameterName(parameterName) || (propertyValue = this.getPropertyValue(mainAttachment, propertyName, false)) == null) continue;
                    if (VWStringUtils.compare(parameterName, "F_Subject") == 0) {
                        if (!(propertyValue instanceof String)) continue;
                        this.m_vwStepElement.setParameterValue(parameterName, propertyValue, true);
                        continue;
                    }
                    Object parameterValue = this.m_vwStepElement.getParameterValue(parameterName);
                    if (parameterValue == null) continue;
                    try {
                        if (parameterValue instanceof Integer ? !(propertyValue instanceof Integer) : (parameterValue instanceof Integer[] ? !(propertyValue instanceof Integer[]) : (parameterValue instanceof String ? !(propertyValue instanceof String) : (parameterValue instanceof String[] ? !(propertyValue instanceof String[]) : (parameterValue instanceof Double ? !(propertyValue instanceof Double) : (parameterValue instanceof Double[] ? !(propertyValue instanceof Double[]) : (parameterValue instanceof Boolean ? !(propertyValue instanceof Boolean) : (parameterValue instanceof Boolean[] ? !(propertyValue instanceof Boolean[]) : (parameterValue instanceof Date ? !(propertyValue instanceof Date) : parameterValue instanceof Date[] && !(propertyValue instanceof Date[])))))))))) continue;
                        this.m_vwStepElement.setParameterValue(parameterName, propertyValue, true);
                    }
                    catch (Exception ex1) {
                        VWDebug.logException(ex1);
                    }
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private Object getPropertyValue(IVWIDMItem mainAttachment, String propertyName, boolean bIsArrayParameter) {
        try {
            Date[] propertyValue = mainAttachment.getProp(propertyName);
            if (propertyValue != null) {
                if (propertyValue.getClass().isArray()) {
                    if (propertyValue instanceof GregorianCalendar[]) {
                        GregorianCalendar[] gCalendar = (GregorianCalendar[])propertyValue;
                        SimpleDateFormat dateFormat = new SimpleDateFormat();
                        Date[] dateArray = new Date[gCalendar.length];
                        for (int i = 0; i < gCalendar.length; ++i) {
                            dateArray[i] = dateFormat.parse(gCalendar[i].toString());
                        }
                        propertyValue = dateArray;
                    }
                } else if (propertyValue instanceof GregorianCalendar) {
                    SimpleDateFormat dateFormat = new SimpleDateFormat();
                    propertyValue = dateFormat.parse(((GregorianCalendar)propertyValue).toString());
                } else if (propertyValue instanceof Long) {
                    propertyValue = new Double(((Long)propertyValue).doubleValue());
                } else if (propertyValue instanceof Short) {
                    propertyValue = new Integer(((Short)propertyValue).intValue());
                }
            }
            return propertyValue;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }
}

